<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Blog;

use Illuminate\Support\Facades\Validator; 

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($slug)
    {
        $data = Blog::where('bg_slug','=',$slug)->first(); 
        return response()->json([
            'code' => 200,
            'success' => True,
            'blog' => $data,
        ]);
        
    }
    
    
    public function blog_list()
    {
        $data = Blog::all(); 
        return response()->json([
            'code' => 200,
            'success' => True,
            'blog' => $data,
            
        ]);
        
    }
    
        
    public function blog_side_list()
    {
        $data = Blog::limit(5)->latest()->get(); 
        return response()->json([
            'code' => 200,
            'success' => True,
            'blog' => $data,
            
        ]);
        
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data=cms::find($id);
        return response()->json([
        'status'=>200,
        'cms'=>$data
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
