<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Product;
use App\Models\Certificate;
use App\Models\Client;
use Illuminate\Support\Facades\Validator;  
use DB;

class HomePageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function product_listing()
    {
       $data=Product::select('product_id','product_name','product_slug','product_image')->limit(8)->get();
	   return response()->json([
	   'status'=>200,
	   'product'=>$data
	   ]);
    }

    public function certificate_listing()
    {
       $data=Certificate::limit(3)->get();
	   return response()->json([
	   'status'=>200,
	   'certificate'=>$data
	   ]);
    }
  
      public function client_listing()
    {
       $data=Client::limit(15)->get();
	   return response()->json([
	   'status'=>200,
	   'client'=>$data
	   ]);
    }
    
          public function category_listing()
    {
    //       $data = Category::leftJoin('product', 'product.product_category', '=', 'category.cat_id')
    // ->select('category.*', DB::raw("SUBSTRING_INDEX(GROUP_CONCAT(product.product_image ORDER BY product.product_id  ASC), ',', 1) AS product_image"))
    // ->groupBy('category.cat_id')
    //   ->where('category.parent_id', '=', 0)
    // ->get();
    
  

    // $data = Category::leftJoin('product', 'product.product_category', '=', 'category.cat_id')
    // ->select('category.*', DB::raw("COALESCE(
    //     (
    //         SELECT SUBSTRING_INDEX(GROUP_CONCAT(sub_product.product_image ORDER BY sub_product.product_id ASC), ',', 1)
    //         FROM category AS sub_category
    //         LEFT JOIN product AS sub_product ON sub_product.product_category = sub_category.cat_id
    //         WHERE sub_category.parent_id = category.cat_id
    //     ),
    //     SUBSTRING_INDEX(GROUP_CONCAT(product.product_image ORDER BY product.product_id ASC), ',', 1)
    // ) AS product_image"))
    // ->groupBy('category.cat_id')
    // ->where('category.parent_id', '=', 0)
    // ->get();

$mainCategories = Category::where('parent_id', '=', 0)->get();
$result = [];
foreach ($mainCategories as $mainCategory) {
    $subCategories = Category::where('parent_id', '=', $mainCategory->cat_id)->get();

    if ($subCategories->isEmpty()) {
        $product = Product::whereRaw("FIND_IN_SET(".$mainCategory->cat_id.", product_category)")
            ->orderBy('product_id', 'ASC')
            ->first();

        $image = $product ? $product->product_image : null;
    } else {
        $subProductImages = [];

        foreach ($subCategories as $subCategory) {
            $subProduct = Product::whereRaw("FIND_IN_SET(".$subCategory->cat_id.", product_category)")
                ->orderBy('product_id', 'ASC')
                ->first();

            if ($subProduct) {
                $subProductImages[] = $subProduct->product_image;
            }
        }

        $image = count($subProductImages) > 0 ? $subProductImages[0] : null;
    }

    $mainCategory->product_image = $image;
    $result[] = $mainCategory;
}



     
	   return response()->json([
	   'status'=>200,
	   'category'=>$result
	   ]);
    }
    
  public function menu_category()

    {

    
       $category = Category::all();
        
       
       $result = Category::all()->toArray();


       $my_category_tree = $this->buildTree($result,0);

       

        return response()->json([

            'code' => 200,

            'success' => True,

            'category' => $my_category_tree,
       

        ]);

    }


public function buildTree(array &$elements, $parentId = 0)
{
    $branch = array();

    foreach ($elements as $element) {
        if ($element['parent_id'] == $parentId) {
            $children = $this->buildTree($elements, $element['cat_id']);
            
            $isMainCategory = $element['parent_id'] === 0;
            $hasChildCategories = Category::where('parent_id', '=', $element['cat_id'])->count() > 0;
            
            $element['children'] = [];
            if ($isMainCategory && !$hasChildCategories) {
                // Fetch products directly associated with the current main category
           $products = Product::leftJoin('category_product', 'product.product_id', '=', 'category_product.product_id')
   
    ->select('product.*', 'category_product.order_by')
    ->orderBy('category_product.order_by', 'ASC')
    ->where('category_product.category_id', '=', $element['cat_id'])
    ->groupBy('product.product_id', 'category_product.order_by') // Add category_product.order_by to GROUP BY
    ->get();



                if (count($products) > 0) {
                    $element['product'] = $products;
                }
            } else if (count($children) > 0) {
                $element['children'] = $children;
            }
            
            $branch[] = $element;
            unset($elements[$element['cat_id']]);
        }
    }

    return $branch;
}


    
          public function FilterProduct()
    {
      

        $industry_id = $_GET['industry_id'];
  
        $application_id = $_GET['application_id'];
        
           if (empty($industry_id) && empty($application_id)) {
        return response()->json([
            'code' => 400,
            'success' => false,
            'message' => 'Please select an industry or application.'
        ]);
    }
     
        $products = DB::table('product')->select(['product.product_name','product.product_image','product.product_slug',]);
            
        
        if($industry_id && $industry_id != ''){
            $products->whereRaw('FIND_IN_SET(' . $industry_id . ',product_industry)');
        }
        
        if($application_id && $application_id != ''){
            $products->whereRaw('FIND_IN_SET(' . $application_id . ',product_application)');
        }
     
        $products->orderBy('product.product_id','DESC');
        $products->groupBy('product.product_id');

        $products = $products->get();
        $ql = "SELECT application_id FROM industry WHERE id  = " . $industry_id . "";
        $data = DB::select($ql);
        
  $application = DB::select("SELECT * FROM application WHERE id IN (".$data[0]->application_id. ") ORDER BY name ASC");
  
        return response()->json([
            'code' => 200,
            'success' => True,
            'products' => $products,
            'application'=> $application
          
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

	
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       
    }
}
