<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Infrastructure;

class InfrastructureController extends Controller
{
    /**
     * Return all infrastructure images in JSON format
     */
    public function allImages()
    {
        $infrastructures = Infrastructure::latest()->get();

        $data = $infrastructures->map(function($item) {
            return [
                'id' => $item->id,
                'image' => $item->image,
            ];
        });

        return response()->json([
            'status' => 'success',
            'data' => $data
        ], 200);
    }
}
