<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Product;
use App\Models\Industry;
use DB;

use Illuminate\Support\Facades\Validator;  

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function allshow()
    {
         $data=Product::all();

  // foreach($data as $key=>$product){
      
  //     $product_id = $product->product_id;
  //            $category_id = $product->product_category;
  //           $category_array = explode(',',$category_id);
  //           if(count($category_array) > 0){
  //               $category = DB::table('category')->whereIn('cat_id', $category_array)->get();
  //           }else{
  //               $category = [];
  //           }
  //           $product->category = $category;
            
  //           $product_image = DB::table('product_image')->where('product_id', $product_id)->get();
  //           $product->gallery_image = $product_image;
  // }

     
       return response()->json([
       'status'=>200,
       'product'=>$data
       ]);
    }
    public function home_product_listing()
    {
        // $data = Product::limit(7)->get();
        $data = Product::query()
        ->inRandomOrder()
        ->take(7)
        ->get();
        return response()->json([
            'status'=>200,
            'product'=>$data
        ]);
    }


    public function product_detail($slug)
    {
       $product=Product::where('product_slug','=',$slug)
        ->leftJoin('category', 'product.product_category', '=', 'category.cat_id')
        ->select(['product.*','category.cat_name','category.slug'])
        ->first();
        

            
          $product_id = $product->product_id;
          
         $product_image = DB::table('product_image')->where('product_id', $product_id)->get();
        $product->gallery_image = $product_image;
         if($product->product_industry){
        $industryIds = explode(',', $product->product_industry);
        $industries = Industry::whereIn('id', $industryIds)->select('id','name','slug','ind_ico')->get();

                $product->industries = $industries;
           } else {
                $product->industries = [];
           }

	   return response()->json([
	   'status'=>200,
	   'product'=>$product
	   ]);
    }
    
public function product_category($slug)
{
    $category = Category::where('slug', '=', $slug)
        ->select('cat_id', 'cat_name', 'cat_img', 'main_image', 'slug', 'full_desc', 'faqs','meta_title', 'meta_keyword', 'meta_desc')
        ->first();

    $category_child = [];
    $product = []; 

    if ($category) {
        $category_id = $category->cat_id;

        $category_parent = Category::where('parent_id', '=', $category_id)->get();

        if (count($category_parent) > 0) {
          
            
               $category_child = Category::where('parent_id', '=', $category_id)
                  ->leftJoin('product', 'product.product_category', '=', 'category.cat_id')
    ->select('category.*', DB::raw("SUBSTRING_INDEX(GROUP_CONCAT(product.product_image ORDER BY product.product_id  ASC), ',', 1) AS product_image"))
    ->groupBy('category.cat_id')
    ->get();
        } else {
            // $product = Product::leftJoin('category_product', 'product.product_id', '=', 'category_product.product_id')
            // ->select('product.*', 'category_product.order_by')
            // ->orderBy('category_product.order_by', 'ASC')
            // ->where('category_product.category_id', '=', $category_id)
            // ->groupBy('product.product_id', 'category_product.order_by') // Add category_product.order_by to GROUP BY
            // ->get();
            $products = Product::where('product_category', $category_id)
            ->orderBy('product_id', 'ASC')
            ->get();

        }

        return response()->json([
            'status' => 200,
            'category' => $category,
            'category_child' => $category_child,
            'products' => $products,
        ]);
    } else {
        return response()->json([
            'status' => 404,
            'message' => 'No record found',
        ]);
    }
}



    public function allcategory()
    {
         $data=Category::select(['category.cat_id','category.cat_name','category.main_image','category.cat_img','category.slug','order_by','meta_title','meta_keyword','meta_desc'])->orderBy('order_by','ASC')->get();
        
        foreach($data as $key=>$category){        
            $category_id = $category->cat_id;
            $product_detail = DB::table('product')->where('product_category', $category_id)
            ->select('product.product_id','product.product_name','product.product_slug','alt_tag','meta_title','meta_keywords','meta_description')->get();
            $category->product = $product_detail;
        }
	   return response()->json([
	   'status'=>200,
	   'category'=>$data
	   ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

	
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       
    }
}
