<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Application;
use DataTables;
use File;
use Alert;
use Illuminate\Support\Str;
class ApplicationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $application = Application::all();
        return view('application.view',compact('application'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('application.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'=> 'required',
        ]);

        $application = new Application;
        
        $application->name = $request->name;

        $application->slug= Str::slug($request->name);

        $application->save();


        Alert::success('Done', 'You\'ve Successfully Add Application');
         return redirect('/application/view');
    }
    
    

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $application = Application::find($id);  
        return view('application.edit',compact('application'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
          $request->validate([
           'name'=> 'required',
        ]);


        $application = Application::where('id', $request->id)->first();
        $application->name = $request->name;
      $application->slug= $request->slug;
        $application->update();    
         
         Alert::success('Done', 'You\'ve Successfully Update Application');
        return redirect('/application/edit/'.$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $application=Application::find($id);
        $application->delete();
        Alert::success('Done', 'You\'ve Successfully Delete Application');
        return back();

    }
}
