<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Blog;
use DataTables;
use File;
use Alert;
use Illuminate\Support\Str;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $blog=Blog::all();
        return view('blog.view',compact('blog'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('blog.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'bg_title'=> 'required',
            'bg_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $blog = new Blog;
        $blog->bg_title = $request->bg_title;
        $blog->bg_shrt_desc = $request->bg_shrt_desc;
        $blog->bg_full_desc = $request->bg_full_desc;        
        $blog->bg_slug= Str::slug($request->bg_title);
        $blog->meta_title=$request->meta_title;
        $blog->meta_description=$request->meta_description;
        $blog->meta_keywords=$request->meta_keywords;
        $blog->alt_tag=$request->alt_tag;
        if($request->hasfile('bg_image'))
        {
            $file = $request->file('bg_image');
            $extention = $file->getClientOriginalExtension();
            $filename = time().'.'.$extention;
            $file->move('public/upload/blog', $filename);
            $blog->bg_image = $filename;
        }
        $blog->save();


        Alert::success('Done', 'You\'ve Successfully Add Blog');
        return redirect('/blog/view');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $blog = Blog::find($id);  
        return view('blog.edit',compact('blog'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'bg_title'=> 'required',
            'bg_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);



        $blog = Blog::where('bg_id', $id)->first();
        $blog->bg_title = $request->bg_title;
        $blog->bg_shrt_desc = $request->bg_shrt_desc;
        $blog->bg_full_desc = $request->bg_full_desc;
        $blog->bg_slug= $request->bg_slug;
        $blog->meta_title=$request->meta_title;
        $blog->meta_description=$request->meta_description;
        $blog->meta_keywords=$request->meta_keywords;
        $blog->alt_tag=$request->alt_tag;

        if($request->hasfile('bg_image'))
        {
            $destination = 'public/upload/blog'.$blog->bg_image;
            if(File::exists($destination))
            {
                File::delete($destination);
            }
            $file = $request->file('bg_image');
            $extention = $file->getClientOriginalExtension();
            $filename = time().'.'.$extention;
            $file->move('public/upload/blog', $filename);
            $blog->bg_image = $filename;
        }

  
         $blog->update();  

         Alert::success('Done', 'You\'ve Successfully Update Blog');
         return redirect('/blog/edit/'.$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $blog=Blog::find($id);
        $blog->delete();
        Alert::success('Done', 'You\'ve Successfully Delete Blog');
        return back();

    }
}
