<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Client;
use DataTables;
use File;
use Alert;

class ClientController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data=Client::all();
        return view('client.view',["client_arr"=>$data]);

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('client.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'client_name'=> 'required',
            'client_logo' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

            $client = new Client;
            $client->client_name = $request->client_name;
            $client->client_alt_tag = $request->client_alt_tag;
            $client->client_desc = $request->client_desc;
            if($request->hasfile('client_logo'))
            {
                $file = $request->file('client_logo');
                $extention = $file->getClientOriginalExtension();
                $filename = time().'.'.$extention;
                $file->move('public/upload/client', $filename);
                $client->client_logo = $filename;
            }
            $client->save();


        Alert::success('Done', 'You\'ve Successfully Add Client');
        return redirect('/client/view');
 
    }
    
    public function saveclientimage(Request $request){
      
        $client = new Client;

        if($request->hasfile('file'))
        {
            $file = $request->file('file');
            $original_name = $file->getClientOriginalName();
        
            $name = basename($request->file('file')->getClientOriginalName(), '.'.$request->file('file')->getClientOriginalExtension());
            $extention = $file->getClientOriginalExtension();
            $filename = $name.'-'.time().'.'.$extention;
            $file->move('public/upload/client', $filename);
            $client->client_logo = $filename;
        }
        $client->save();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $client = Client::find($id);  
        return view('client.edit',compact('client'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'client_logo' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);


        $client = Client::where('client_id', $request->id)->first();
        $client->client_title = $request->client_title;
      $client->client_desc = $request->client_desc;

        if($request->hasfile('client_logo'))
        {
            $destination = 'public/upload/client'.$client->client_logo;
            if(File::exists($destination))
            {
                File::delete($destination);
            }
            $file = $request->file('client_logo');
            $extention = $file->getClientOriginalExtension();
            $filename = time().'.'.$extention;
            $file->move('public/upload/client', $filename);
            $client->client_logo = $filename;
        }

      
  
         $client->update();     
         Alert::success('Done', 'You\'ve Successfully Update Client');
         return redirect('/client/edit/' .$id);
         
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $client=Client::find($id);
        $client->delete();
        Alert::success('Done', 'You\'ve Successfully Delete Client');
        return back();


    }


}
