<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Infrastructure;
use DataTables;
use File;
use Alert;

class InfrastructureController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $infrastructure = Infrastructure::latest()->get();
        return view('infrastructure.view', compact('infrastructure'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('infrastructure.add');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $infrastructure = new Infrastructure;

        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '.' . $extension;
            $file->move('public/upload/infrastructure', $filename);
            $infrastructure->image = $filename;
        }

        $infrastructure->save();

        Alert::success('Done', 'You\'ve Successfully Added Infrastructure');
        return back();
    }

    /**
     * Drag-and-drop upload method
     */
    public function saveInfrastructureImage(Request $request)
    {
        $infrastructure = new Infrastructure;

        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $name = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $extension = $file->getClientOriginalExtension();
            $filename = $name . '-' . time() . '.' . $extension;
            $file->move('public/upload/infrastructure', $filename);
            $infrastructure->image = $filename;
        }

        $infrastructure->save();
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $infrastructure = Infrastructure::find($id);
        return view('infrastructure.edit', compact('infrastructure'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $infrastructure = Infrastructure::find($id);

        if ($request->hasFile('image')) {
            $destination = 'public/upload/infrastructure/' . $infrastructure->image;
            if (File::exists($destination)) {
                File::delete($destination);
            }

            $file = $request->file('image');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '.' . $extension;
            $file->move('public/upload/infrastructure', $filename);
            $infrastructure->image = $filename;
        }

        $infrastructure->update();
        Alert::success('Done', 'You\'ve Successfully Updated Infrastructure');
        return redirect('/infrastructure/view');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $infrastructure = Infrastructure::find($id);
        $infrastructure->delete();
        Alert::success('Done', 'You\'ve Successfully Deleted Infrastructure');
        return back();
    }
}
