<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\ProductImage;
use App\Models\Category;
use App\Models\Industry;
use App\Models\Application;
use File;
use Alert;
use Illuminate\Support\Str;
use App\Models\CategoryProduct;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data=product::leftJoin('category', 'product.product_category', '=', 'category.cat_id')
                     ->select(['product.*','category.cat_name'])
                     ->get();

        return view('product.view',["product_arr"=>$data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       $category = Category::all();
        $industry = Industry::all();
        $application = Application::all();
        return view('product.add',compact('category','industry','application'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=$request->validate([
            'product_name' => 'required',
            'product_image' => 'mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
        ]);
        $data=new product;
        $data->product_name=$request->product_name;
        $data->product_slug= Str::slug($request->product_name);
        $data->full_desc=$request->full_desc;
        $data->desc_2=$request->desc_2;
        // $data->desc_3=$request->desc_3;
        $data->menu_title=$request->menu_title;
        
        $data->meta_title=$request->meta_title;
        $data->meta_description=$request->meta_description;
        $data->meta_keywords=$request->meta_keywords;
        $data->alt_tag=$request->alt_tag;
        // $data->product_video=$request->product_video;
        $data->shrt_desc=$request->shrt_desc;
        // $data->faqs=$request->faqs;

   
        // if($request->product_application){
        //     $data->product_application = implode(',',$request->product_application);
        // }else{
        //     $data->product_application = '';
        // }
        if($request->category_id){
            $data->product_category = $request->category_id;
        }else{
            $data->product_category = '';
        }
        if($request->industry){
            $data->product_industry = implode(',',$request->industry);
        }else{
            $data->product_industry = '';
        }

        if($request->hasfile('product_image'))
        {
            $file = $request->file('product_image');
            $extention = $file->getClientOriginalExtension();
            $randomNumber = random_int(100000, 999999);
            $filename = time().$randomNumber.'.'.$extention;
            $file->move('public/upload/product', $filename);
            $data->product_image = $filename;
        }
        
        if ($request->hasFile('brochure_pdf')) {
            $file = $request->file('brochure_pdf');
            $originalName = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $slugName = Str::slug($originalName);
            $extension = strtolower($file->getClientOriginalExtension());
            $filename = $slugName . '.' . $extension;
            $file->move(public_path('public/upload/pdf'), $filename);
            $data->brochure_pdf = $filename;
        }

        
        $data->save();

        // if($request->product_multi_image)
        // {
        //     foreach($request->product_multi_image as  $photo)
        //     {
        //         $name = $photo->getClientOriginalName();
        //         $photo->move('public/upload/product',$name);
        //         $Image[] = $name;
    
        //         $product_image = new ProductImage;
        //         $product_image->product_id = $data->product_id;
        //         $product_image->product_multi_image = $name;
    
        //         $product_image->save();
        //     }
        // }
        if($request->hasFile('product_multi_image')){
            foreach($request->file('product_multi_image') as $photo){
                $extension=$photo->getClientOriginalExtension();
                $filename=time().random_int(100000,999999).'.'.$extension;
                $photo->move('public/upload/product',$filename);
                $Image[]=$filename;
                $product_image=new ProductImage;
                $product_image->product_id=$data->product_id;
                $product_image->product_multi_image=$filename;
                $product_image->save();
            }
        }

         
        // foreach($request->product_category as  $category)
        // {
        //     $category_data = new CategoryProduct;
        //     $category_data->product_id = $data->product_id;
        //     $category_data->category_id = $category;
            
        //     $category_data->save();
        // }

        Alert::success('Done', 'You\'ve Successfully Add Product');
        return redirect('/product/view');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $product=product::find($id);
        $category = Category::all();
 
        $product_image = ProductImage::where('product_id','=',$id)->get();
        $industry = Industry::all();
        $application = Application::all();
        $category_product = CategoryProduct::where('product_id','=',$id)->get();
        return view('product.edit',compact('product','category','product_image','industry','application','category_product'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data=$request->validate([
            'product_name' => 'required',
             'product_image' => 'mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
         
        ]);
        $data = product::where('product_id', $id)->first();

        $data->product_name=$request->product_name;
        $data->product_slug= $request->product_slug;
        $data->full_desc=$request->full_desc;
        $data->desc_2=$request->desc_2;
        // $data->desc_3=$request->desc_3;
        $data->menu_title=$request->menu_title;
        
        
        $data->meta_title=$request->meta_title;
        $data->meta_description=$request->meta_description;
        $data->meta_keywords=$request->meta_keywords;
         $data->alt_tag=$request->alt_tag;
        // $data->product_video=$request->product_video;
        $data->shrt_desc=$request->shrt_desc;
        // $data->faqs=$request->faqs;

        if($request->category_id){
            $data->product_category = $request->category_id;
        }else{
            $data->product_category = '';
        }
        // if($request->product_application){
        //     $data->product_application = implode(',',$request->product_application);
        // }else{
        //     $data->product_application = '';
        // }
        if($request->industry){
            $data->product_industry = implode(',',$request->industry);
        }else{
            $data->product_industry = '';
        }

        if($request->hasfile('product_image'))
        {
            $destination = 'public/upload/product'.$data->product_image;
            if(File::exists($destination))
            {
                File::delete($destination);
            }
            $file = $request->file('product_image');
            $extention = $file->getClientOriginalExtension();
            $randomNumber = random_int(100000, 999999);
            $filename = time().$randomNumber.'.'.$extention;
            $file->move('public/upload/product', $filename);
            $data->product_image = $filename;
         }
         if ($request->hasFile('brochure_pdf')) {
            $file = $request->file('brochure_pdf');
            $originalName = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $slugName = Str::slug($originalName);
            $extension = strtolower($file->getClientOriginalExtension());
            $filename = $slugName . '.' . $extension;
            $file->move(public_path('public/upload/pdf'), $filename);
            $data->brochure_pdf = $filename;
        }

        //  if($request->hasfile('pack_image'))
        // {
        //     $destination = 'public/upload/product'.$data->pack_image;
        //     if(File::exists($destination))
        //     {
        //         File::delete($destination);
        //     }
        //     $file = $request->file('pack_image');
        //     $extention = $file->getClientOriginalExtension();
        //     $randomNumber = random_int(100000, 999999);
        //     $filename = time().$randomNumber.'.'.$extention;
        //     $file->move('public/upload/product', $filename);
        //     $data->pack_image = $filename;
        //  }
         


        // echo "<pre>";
        // print_r($data);
        // exit;
        $data->update();
        
        // if ($request->has('category_id')) {
        //     $selectedCategoryIds = $request->input('category_id');
            
        //     // Update existing category associations
        //     $data->categories()->sync($selectedCategoryIds);
        
        //     // Create new category associations
        //     foreach ($selectedCategoryIds as $category_id) {
        //         if (!$data->categories->contains($category_id)) {
        //             $data->categories()->attach($category_id);
        //         }
        //     }
        // }

        
        // if($request->product_multi_image)
        // {

        //     foreach($request->product_multi_image as  $photo)
        //     {
        //         $name = $photo->getClientOriginalName();
        //         $path =  $photo->move('public/upload/product',$name);
        //         $Image[] = $name;
        //         $product_image = new ProductImage;
        //         $product_image->product_id = $id;
        //         $product_image->product_multi_image = $name;

        //         $product_image->save();
        //     }
        // }
        if ($request->hasFile('product_multi_image')) {
            foreach ($request->file('product_multi_image') as $photo) {
                $extension = $photo->getClientOriginalExtension();
                $randomNumber = random_int(100000, 999999);
                $filename = time() . $randomNumber . '.' . $extension;
                $photo->move('public/upload/product', $filename);
                $product_image = new ProductImage();
                $product_image->product_id = $id;
                $product_image->product_multi_image = $filename;
                $product_image->save();
            }
        }

       
        Alert::success('Done', 'You\'ve Successfully Update Product');
        return redirect('/product/edit/'.$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data=Product::find($id);
        $data->delete();
  
      
        Alert::success('Done', 'You\'ve Successfully Delete Product');
        return back();
    }

     public function destroyImage($id)
    {
        $product_image = ProductImage::findOrFail($id);

        $destination = public_path().'/public/upload/product/'.$product_image->product_multi_image;

        if(file_exists($destination))
        {
            unlink($destination);
        }
        $product_image->delete();

        return response()->json([
            'success' => 'Image deleted successfully!'
        ]);
    }


 
}
