@extends('Admin.Layout.main_layout') 	
@section('main_container')
<!-- begin app-main -->
<div class="app-main" id="main">
   <!-- begin container-fluid -->
   <div class="container-fluid">
      <!-- begin row -->
      <div class="row">
         <div class="col-md-12 m-b-30">
            <!-- begin page title -->
            <div class="d-block d-sm-flex flex-nowrap align-items-center">
               <div class="page-title mb-2 mb-sm-0">
                  <h1>Blog</h1>
               </div>
               <div class="ml-auto d-flex align-items-center">
                  <a class="btn btn-secondary" href="{{ route('blog') }}">Manage Blog</a>
               </div>
            </div>
            <!-- end page title -->
         </div>
      </div>
      <!-- end row -->
      <!--mail-Compose-contant-start-->
      <div class="row account-contant">
         <div class="col-12">
            <div class="card card-statistics">
               <div class="card-body p-0">
                  <!-- <div class="row no-gutters"> -->
                  <div class="page-account-form">
                     <div class="form-titel border-bottom p-3">
                        <h5 class="mb-0 py-2">Update Blog</h5>
                     </div>
                     <div class="p-3">
                        <form role="form" method="POST" enctype="multipart/form-data" action="{{ route('updateBlog', $blog->bg_id) }}">
                           @csrf
                           <div class="row">
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Blog Name<span style="color:#ff0000">*</span></label>
                                    <input class="form-control" value="{{ $blog->bg_title }}"  placeholder="Enter Blog Name" name="bg_title" type="text" required>
                                    @error('bg_title')
                                    <p class="text-danger"><small>{{ $message }}</small></p>
                                    @enderror
                                 </div>
                              </div>
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Blog Image</label>
                                    <input class="form-control" name="bg_image" type="file">
                                    @if($blog->bg_image)
                                    <img src="{{ URL('public/upload/blog') }}/{{ $blog->bg_image }}" alt="" height="100px" width="100px">
                                    @endif
                                    @error('bg_image')
                                    <p class="text-danger"><small>{{ $message }}</small></p>
                                    @enderror
                                 </div>
                              </div>
                           </div>
                              <div class="row">
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Blog Slug</label>
                                    <input class="form-control" value="{{ $blog->bg_slug }}"  placeholder="Enter Blog Slug" name="bg_slug" type="text">
                                   
                                 </div>
                              </div>
                              </div>
                           <div class="row">
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Short Description</label>
                                    <textarea class="form-control" value="{{ old('bg_shrt_desc') }}" name="bg_shrt_desc" cols="50" rows="15" style="width:100%;px; height:300px;" mce_editable="true">{{ $blog->bg_shrt_desc }}</textarea>
                                 </div>
                              </div>
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Full Description</label>
                                    <textarea id="editor_desc" class="ckeditor form-control" name="bg_full_desc" cols="50" rows="15" style="width:100%;px; height:300px;" mce_editable="true">{{ $blog->bg_full_desc }}</textarea>
                                 </div>
                              </div>
                           </div>
                           <div class="row">
                                  <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Alt Tag</label>
                                    <input class="form-control" value="{{ $blog->alt_tag }}"  placeholder="Enter Alt Tag" name="alt_tag" type="text">
                                   
                                 </div>
                              </div>
                            
                           </div>
                            <div class="form-titel border-bottom p-3">
                              <h5 class="mb-0 py-2">SEO Feilds</h5>
                           </div>
                           <div class="row">
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Meta Title</label>
                                    <input type="text" class="form-control" value="{{ $blog->meta_title }}" placeholder="Enter Meta Title" name="meta_title">
                                 </div>
                              </div>
                                     <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Keywords</label>
                                    <input class="form-control" value="{{ $blog->meta_keywords }}"  placeholder="Enter Meta Keywords" name="meta_keywords" type="text">
                                 </div>
                              </div>
                           </div>
                            <div class="row">
                              <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Meta Description</label> 
                                    <textarea class="form-control"  name="meta_description" cols="50" rows="15" style="width:100%;px; height:300px;" mce_editable="true">{{ $blog->meta_description }}</textarea>
                                 </div>
                              </div>
                           </div>
                           <div class="row">
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="text-left">
                                    <button type="submit" id="submit" class="btn btn-secondary my-4">Update</button>
                                    <a href="{{ route('blog') }}" class="btn btn-danger my-4">Cancel</a>
                                 </div>
                              </div>
                           </div>
                        </form>
                     </div>
                  </div>
                  <!-- </div> -->
               </div>
            </div>
         </div>
      </div>
      <!--mail-Compose-contant-end-->
   </div>
   <!-- end container-fluid -->
</div>
<!-- end app-main -->
</div>
<!-- end app-container -->
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
   $(document).ready(function () {
   
     //   $('.ckeditor').ckeditor();

       var my_desc = CKEDITOR.replace('editor_desc');
       my_desc.config.allowedContent = true;
       my_desc.config.extraAllowedContent = 'div(*)';
       my_desc.config.extraAllowedContent = 'div(col-md-*,container-fluid,row)';
   
  
   });
   
</script>
@endsection
