@extends('Admin.Layout.main_layout') 	
@section('main_container')
<!-- begin app-main -->
<div class="app-main" id="main">
   <!-- begin container-fluid -->
   <div class="container-fluid">
      <!-- begin row -->
      <div class="row">
         <div class="col-md-12 m-b-30">
            <!-- begin page title -->
            <div class="d-block d-sm-flex flex-nowrap align-items-center">
               <div class="page-title mb-2 mb-sm-0">
                  <h1>CMS</h1>
               </div>
               <div class="ml-auto d-flex align-items-center">
                <a class="btn btn-secondary" href="{{ route('cms') }}">Manage CMS</a>
               </div>
            </div>
            <!-- end page title -->
         </div>
      </div>
      <!-- end row -->
      <!--mail-Compose-contant-start-->
      <div class="row account-contant">
         <div class="col-12">
            <div class="card card-statistics">
               <div class="card-body p-0">
                  <!-- <div class="row no-gutters"> -->
                     <div class="page-account-form">
                        <div class="form-titel border-bottom p-3">
                           <h5 class="mb-0 py-2">Update CMS</h5>
                        </div>
                        <div class="p-3">
                           <form role="form" method="POST" enctype="multipart/form-data" action="{{ route('updateCMS', $cms->id) }}">
                              @csrf
                              <div class="row">
                                 <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                    <label>Page Title</label>
                                    <input type="text" class="form-control" name="page_title" value="{{ $cms->page_title  }}"  placeholder="Enter Page Title">
                                       @error('page_title')
                                       <p class="text-danger"><small>{{ $message }}</small></p>
                                       @enderror
                                    </div>
                                 </div>
                                 <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                    <label>Page Slug</label>
                                    <input type="text" class="form-control" name="slug" value="{{ $cms->slug }}"  placeholder="Enter Page Slug">
                                    </div>
                                 </div>
                                 <!-- <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                       <label>Banner Image<span style="color:#ff0000">*</span></label>
                                       <input class="form-control" name="banner_img" type="file">
                                       @if($cms->banner_img)
                                       <img src="{{ URL('public/upload/cms') }}/{{ $cms->banner_img }}" alt="" height="100px" width="100px">
                                       @endif
                                       @error('banner_img')
                                       <p class="text-danger"><small>{{ $message }}</small></p>
                                       @enderror
                                    </div>
                                 </div> -->
                              </div>
                              <div class="row">
                                 
                                 <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                    <label>Alt Tag</label>
                                    <input type="text" class="form-control" name="alt_tag" value="{{ $cms->alt_tag }}"  placeholder="Enter Alt Tag">
                                    </div>
                                 </div>
                                 <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Page Display</label>
                                     <select name="page_display" class="form-control selectpicker myselectpick"  data-live-search="true">
                                       <option value="">Please select</option>
                                  
                                       <option value="1" {{ $cms->page_display == 1 ? "selected":" " }}>Yes</option>
                                     <option value="2" {{ $cms->page_display == 2 ? "selected":" " }}>No</option>
                                    </select>
                                 </div>
                              </div>
                              </div>
                              
                              <div class="row">
                              <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="form-group">
                                       <label>Page Description</label>
                                       <textarea id="editor_desc" class="ckeditor form-control"  name="description" cols="50" rows="15" style="width:100%;px; height:300px;" mce_editable="true">{{ $cms->description }}</textarea>
                                    
                                    </div>
                                 </div>
                              </div>
                              <div class="form-titel border-bottom p-3">
                                <h5 class="mb-0 py-2">SEO Feilds</h5>
                                </div>
                              <div class="row">
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                    <label>Meta Title</label>
                                    <input type="text" class="form-control" value="{{ $cms->meta_title }}" placeholder="Enter Meta Title" name="meta_title">
                                    </div>
                                 </div>
                                 <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                       <label>Meta Description</label>
                                       <input class="form-control" value="{{ $cms->meta_description }}"  placeholder="Enter Meta Description" name="meta_description" type="text">
                                    </div>
                                 </div>
                              </div>
                              <div class="row">
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                       <label>Keywords</label>
                                       <input class="form-control" value="{{ $cms->meta_keywords }}"  placeholder="Enter Meta Keywords" name="meta_keywords" type="text">
                                    </div>
                                 </div>
                              </div>
                             
                              <div class="row">
                                 <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="text-left">
                                       <button type="submit" id="submit" class="btn btn-secondary my-4">Update</button>
                                       <a href="{{ route('cms') }}"  class="btn btn-danger my-4">Cancel</a>
                                    </div>
                                 </div>
                              </div>
                           </form>
                        </div>
                     </div>
                  <!-- </div> -->
               </div>
            </div>
         </div>
      </div>
      <!--mail-Compose-contant-end-->
   </div>
   <!-- end container-fluid -->
</div>
<!-- end app-main -->
</div>
<!-- end app-container -->
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
      //   $('.ckeditor').ckeditor();
        var my_desc = CKEDITOR.replace('editor_desc');
        my_desc.config.allowedContent = true;
        my_desc.config.extraAllowedContent = 'div(*)';
        my_desc.config.extraAllowedContent = 'div(col-md-*,container-fluid,row)';
    });
</script>
@endsection
