@extends('Admin.Layout.main_layout') 	
@section('title','Manage Product')
@section('main_container')
<!-- begin app-main -->
<div class="app-main" id="main">
   <!-- begin container-fluid -->
   <div class="container-fluid">
      <!-- begin row -->
     <div class="row">
    <div class="col-md-12 m-b-30">
        <!-- begin page title -->
        <div class="d-flex flex-nowrap justify-content-between align-items-center">
            <div class="page-title mb-2 mb-sm-0">
                <h1>Manage Quick Inquiry</h1>
            </div>
      <div class="d-flex align-items-center">
                <form method="get" class="d-flex">
                    <input type="date" class="form-control mr-2" name="start_date" value="{{ request('start_date') }}">
                    <input type="date" class="form-control mr-2" name="end_date" value="{{ request('end_date') }}">
                    <button type="submit" class="btn btn-secondary">Submit</button>
                    <a href="{{ route('quick_inquiry') }}" class="btn btn-danger ml-2">Reset</a>
                    <button type="submit" class="btn btn-danger ml-2" name="export" value="1">Export</button>
                </form>
            </div>


        </div>
        <!-- end page title -->
    </div>
</div>


      <!-- end row -->
      <!-- begin row -->
      <div class="row editable-wrapper">
         <div class="col-lg-12 ">
            <div class="card card-statistics">
               <div class="card-body">
                  <div class="table-responsive">
                     <table id="table" class="table display responsive nowrap table-light table-bordered">
                        <thead class="thead-light">
                           <tr>
                              <th scope="col">id</th>
                              <th scope="col">Name</th>
                             <th scope="col">Product Name</th>
                              <th scope="col">Email</th>
                              <th scope="col">Phone Number</th>
                               <th scope="col">Message</th>
                               <th scope="col">Date</th>
                           </tr>
                        </thead>
                        <tbody>
                        @if(!$cont_arr->isEmpty())
                        @foreach($cont_arr as $key => $data)
                           <tr>
                              <th scope="row">{{ ($key+1) }}</th>
                            
                                <td>{{ $data->full_name }}</td>
                                 <td>{{ $data->product_name }}</td>
                                  <td>{{ $data->email }}</td>
                               <td>{{ $data->phone_number }}</td>
                              <td>{{ $data->additional_details }}</td>
                           <td>{{ date('Y-m-d', strtotime($data->created_at)) }}</td>

                           </tr>
                           @endforeach  
                           @else
                           <p class="text-danger mt-2" style="padding-left:450px;">No Quick Inquiry Available</p>
                           @endif
                        </tbody>
                     </table>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- end row -->
   </div>
   <!-- end container-fluid -->
</div>
<!-- end app-main -->
</div>
<!-- end app-container -->
@endsection