@extends('Admin.Layout.main_layout') 	
@section('main_container')
<!-- begin app-main -->
<div class="app-main" id="main">
   <!-- begin container-fluid -->
   <div class="container-fluid">
      <!-- begin row -->
      <div class="row">
         <div class="col-md-12 m-b-30">
            <!-- begin page title -->
            <div class="d-block d-sm-flex flex-nowrap align-items-center">
               <div class="page-title mb-2 mb-sm-0">
                  <h1>Product</h1>
               </div>
               <div class="ml-auto d-flex align-items-center">
                  <a class="btn btn-secondary" href="{{ route('product') }}">Manage Product</a>
               </div>
            </div>
            <!-- end page title -->
         </div>
      </div>
      <!-- end row -->
      @php
      function categoryTree($parent_id = 0, $sub_mark = ''){
      $query =  DB::table('category')->where('parent_id','=', $parent_id)->get();
      if(count($query) > 0){
      foreach($query as $value){
      $s="";
      echo '<option value="'.$value->cat_id.'" '.$s.' >'.$sub_mark.$value->cat_name.'</option>';
      categoryTree($value->cat_id, $sub_mark.'---');
      }
      }
      }
      @endphp
      <!--mail-Compose-contant-start-->
      <div class="row account-contant">
         <div class="col-12">
            <div class="card card-statistics">
               <div class="card-body p-0">
                  <!-- <div class="row no-gutters"> -->
                  <div class="page-account-form">
                     <div class="form-titel border-bottom p-3">
                        <h5 class="mb-0 py-2">Add Product</h5>
                     </div>
                     <div class="p-3">
                        <form role="form" method="POST" enctype="multipart/form-data" action="{{ route('createProduct') }}">
                           @csrf
                           <div class="row">
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Product Name<span style="color:#ff0000">*</span></label>
                                    <input class="form-control" value="{{ old('product_name') }}"  placeholder="Enter Product Name" name="product_name" type="text" required>
                                    @error('product_name')
                                    <p class="text-danger"><small>{{ $message }}</small></p>
                                    @enderror
                                 </div>
                              </div>
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Product Category<span style="color:#ff0000">*</span></label>
                                    <select name="category_id" class="form-control  selectpicker "  data-show-subtext="true" data-live-search="true">
                                       <option value="">Please Select</option>
                                          @php
                                          echo categoryTree();
                                          @endphp
                                    </select>
                                 </div>
                              </div>
                              <!-- <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Menu Title<span style="color:#ff0000">*</span></label>
                                    <input class="form-control" value="{{ old('menu_title') }}"  placeholder="Enter Product Name" name="menu_title" type="text" required>
                                    @error('menu_title')
                                    <p class="text-danger"><small>{{ $message }}</small></p>
                                    @enderror
                                 </div>
                              </div> -->
                           </div>

                           <div class="row">
                              
                              <!-- <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Pack Image</label>
                                   <input class="form-control"   name="pack_image" type="file">
                                    @error('pack_image')
                                    <p class="text-danger"><small>{{ $message }}</small></p>
                                    @enderror
                                 </div>
                              </div> -->
                                <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                  <div class="form-group">
                                    <label>Industry</label>
                                    <select name="industry[]" class="form-control selectpicker" multiple data-live-search="true">
                                        @foreach($industry as $ind)
                                            <option value="{{ $ind->id }}"
                                                {{ (collect(old('industry'))->contains($ind->id)) ? 'selected' : '' }}>
                                                {{ $ind->name }}
                                            </option>
                                        @endforeach

                                    </select>
                                </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Alt Tag</label>
                                    <input class="form-control" value="{{ old('alt_tag') }}"  placeholder="Enter Alt Tag" name="alt_tag" type="text">
                                   
                                 </div>
                              </div>
                           </div>
                           <div class="row">
                            <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Feature Image</label>
                                   <input class="form-control"   name="product_image" type="file">
                                    @error('product_image')
                                    <p class="text-danger"><small>{{ $message }}</small></p>
                                    @enderror
                                 </div>
                              </div>
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Brochure PDF</label>
                                   <input class="form-control"   name="brochure_pdf" type="file">
                                    @error('brochure_pdf')
                                    <p class="text-danger"><small>{{ $message }}</small></p>
                                    @enderror
                                 </div>
                              </div>
                           </div>

                         
                            <div class="row">
                              <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Short Description</label>
                                    <textarea  id="shrt_desc" class="ckeditorr form-control" name="shrt_desc" cols="50" rows="15" style="width:100%;px; height:300px;" mce_editable="true"></textarea>
                                 </div>
                              </div>
                           </div>
                        
                           <div class="row">
                              <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Full Description</label>
                                    <textarea  id="editor_desc" class="ckeditorr form-control" name="full_desc" cols="50" rows="15" style="width:100%;px; height:300px;" mce_editable="true"></textarea>
                                 </div>
                              </div>
                           </div>
                           <div class="row">
                              <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Description 2</label>
                                    <textarea  id="desc_2" class="ckeditorr form-control" name="desc_2" cols="50" rows="15" style="width:100%;px; height:300px;" mce_editable="true"></textarea>
                                 </div>
                              </div>
                           </div>
                           <!-- <div class="row">
                              <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Description 3</label>
                                    <textarea  id="desc_3" class="ckeditor form-control" name="desc_3" cols="50" rows="15" style="width:100%;px; height:300px;" mce_editable="true"></textarea>
                                 </div>
                              </div>
                           </div>
                           <div class="row">
                              <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Description 4</label>
                                    <textarea  id="desc_4" class="ckeditor form-control" name="desc_4" cols="50" rows="15" style="width:100%;px; height:300px;" mce_editable="true"></textarea>
                                 </div>
                              </div>
                           </div> -->
                            <div class="row">
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Gallery Image<span style="color:#ff0000">*</span></label>
                                    <div class="input-group hdtuto control-group lst increment" >
                                       <input type="file" name="product_multi_image[]" class="myfrm form-control">
                                       <div class="input-group-btn">
                                          <button class="btn btn-success" type="button"><i class="fldemo glyphicon glyphicon-plus"></i>Add</button>
                                       </div>
                                    </div>
                                    <div class="clone hide">
                                       <div class="hdtuto control-group lst input-group" style="margin-top:10px">
                                          <input type="file" name="product_multi_image[]" class="myfrm form-control">
                                          <div class="input-group-btn">
                                             <button class="btn btn-danger" type="button"><i class="fldemo glyphicon glyphicon-remove"></i> Remove</button>
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                           </div>
                           <div class="form-titel border-bottom p-3">
                              <h5 class="mb-0 py-2">SEO Feilds</h5>
                           </div>
                           <div class="row">
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Meta Title</label>
                                    <input type="text" class="form-control" value="{{ old('meta_title') }}" placeholder="Enter Meta Title" name="meta_title">
                                 </div>
                              </div>
                    
                                         <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Keywords</label>
                                    <input class="form-control" value="{{ old('meta_keywords') }}"  placeholder="Enter Meta Keywords" name="meta_keywords" type="text">
                                 </div>
                              </div>
                           </div>
                        
                            <div class="row">
                              <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                 <div class="form-group">
                                    <label>Meta Description</label> 
                                    <textarea class="form-control"  name="meta_description" cols="50" rows="15" style="width:100%;px; height:300px;" mce_editable="true"></textarea>
                                 </div>
                              </div>
                           </div>
                           <div class="row">
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                 <div class="text-left">
                                    <button type="submit" id="submit" class="btn btn-secondary my-4">Add</button>
                                    <a href="{{ route('product') }}"  class="btn btn-danger my-4">Cancel</a>
                                 </div>
                              </div>
                           </div>
                        </form>
                     </div>
                  </div>
                  <!-- </div> -->
               </div>
            </div>
         </div>
      </div>
      <!--mail-Compose-contant-end-->
   </div>
   <!-- end container-fluid -->
</div>
<!-- end app-main -->
</div>
<!-- end app-container -->
<script>
   $(document).ready(function(){
   
       $(".btn-success").click(function(){
             var lsthmtl = $(".clone").html();
             $(".increment").after(lsthmtl);
         });
   
         $("body").on("click",".btn-danger",function(){
             $(this).parents(".hdtuto").remove();
         });
   
        
   
   });
   
    
</script>
<!--<script src="//cdn.ckeditor.com/4.21.0/standard/ckeditor.js"></script>-->
<script type="text/javascript">
   $(document).ready(function () {
   
   
       var my_desc = CKEDITOR.replace('editor_desc');
       my_desc.config.allowedContent = true;
       my_desc.config.extraAllowedContent = 'div(*)';
       my_desc.config.extraAllowedContent = 'div(col-md-*,container-fluid,row)';
   
       var shrt_desc = CKEDITOR.replace('shrt_desc');
       shrt_desc.config.allowedContent = true;
       shrt_desc.config.extraAllowedContent = 'div(*)';
       shrt_desc.config.extraAllowedContent = 'div(col-md-*,container-fluid,row)';
          
       var desc_2 = CKEDITOR.replace('desc_2');
       desc_2.config.allowedContent = true;
       desc_2.config.extraAllowedContent = 'div(*)';
       desc_2.config.extraAllowedContent = 'div(col-md-*,container-fluid,row)';
       // var desc_3 = CKEDITOR.replace('desc_3');
       // desc_3.config.allowedContent = true;
       // desc_3.config.extraAllowedContent = 'div(*)';
       // desc_3.config.extraAllowedContent = 'div(col-md-*,container-fluid,row)';
       // var desc_4 = CKEDITOR.replace('desc_4');
       // desc_4.config.allowedContent = true;
       // desc_4.config.extraAllowedContent = 'div(*)';
       // desc_4.config.extraAllowedContent = 'div(col-md-*,container-fluid,row)';
   });
   
</script>
@endsection