@extends('Admin.Layout.main_layout') 	
@section('main_container')
<!-- begin app-main -->
<div class="app-main" id="main">
   <!-- begin container-fluid -->
   <div class="container-fluid">
      <!-- begin row -->
      <div class="row">
         <div class="col-md-12 m-b-30">
            <!-- begin page title -->
            <div class="d-block d-sm-flex flex-nowrap align-items-center">
               <div class="page-title mb-2 mb-sm-0">
                  <h1>Testimonials</h1>
               </div>
               <div class="ml-auto d-flex align-items-center">
                <a class="btn btn-secondary" href="{{ route('testimonials') }}">Manage Testimonials</a>
               </div>
            </div>
            <!-- end page title -->
         </div>
      </div>
      <!-- end row -->
      <!--mail-Compose-contant-start-->
      <div class="row account-contant">
         <div class="col-12">
            <div class="card card-statistics">
               <div class="card-body p-0">
                  <!-- <div class="row no-gutters"> -->
                     <div class="page-account-form">
                        <div class="form-titel border-bottom p-3">
                           <h5 class="mb-0 py-2">Add Testimonials</h5>
                        </div>
                        <div class="p-3">
                           <form role="form" method="POST" enctype="multipart/form-data" action="{{ route('createTesti') }}">
                              @csrf
                              <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                    <label>Testimonials Title</Title><span style="color:#ff0000">*</span></label>
                                    <input class="form-control" value="{{ old('testi_title') }}" name="testi_title" placeholder="Enter Title" type="text">
                                    @error('testi_title')
                                    <p class="text-danger"><small>{{ $message }}</small></p>
                                    @enderror
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                    <label>Testimonials Company Name</label>
                                    <input class="form-control" value="{{ old('testi_company_name') }}" name="testi_company_name" placeholder="Enter Company Name" type="text">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                              <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                    <label>Testimonials Position</label>
                                    <input class="form-control" value="{{ old('testi_position') }}" name="testi_position" placeholder="Enter Position" type="text">
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                       <label>Testimonials Image</label>
                                       <input class="form-control"  name="testi_image"  type="file">
                                       @error('testi_image')
                                       <p class="text-danger"><small>{{ $message }}</small></p>
                                       @enderror
                                    </div>
                                 </div>
                               
                            </div>
                            <div class="row">
                                 <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                    <label>Description</label>
                                    <textarea id="editor_desc" class="ckeditor form-control" value="{{ old('testi_desc') }}" name="testi_desc" cols="50" rows="15" style="width:100%;px; height:300px;" mce_editable="true"></textarea>
                                    </div>
                                </div>
                             </div>
                              <div class="row">
                                 <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="text-left">
                                       <button type="submit" id="submit" class="btn btn-secondary  my-4">Add</button>
                                       <a href="{{ route('testimonials') }}"  class="btn btn-danger my-4">Cancel</a>
                                    </div>
                                 </div>
                              </div>
                           </form>
                        </div>
                     </div>
                  <!-- </div> -->
               </div>
            </div>
         </div>
      </div>
      <!--mail-Compose-contant-end-->
   </div>
   <!-- end container-fluid -->
</div>
<!-- end app-main -->
</div>
<!-- end app-container -->
@endsection
@push('js')
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
      //   $('.ckeditor').ckeditor();


        var my_desc = CKEDITOR.replace('editor_desc');
        my_desc.config.allowedContent = true;
        my_desc.config.extraAllowedContent = 'div(*)';
        my_desc.config.extraAllowedContent = 'div(col-md-*,container-fluid,row)';

    });
</script>


@endpush