<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\admin_controller;
// use App\Http\Controllers\categorie_controller;
use App\Http\Controllers\product_controller;
use App\Http\Controllers\product_detail_controller;
// use App\Http\Controllers\faq_controller;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware'=>['admin_beforelogin']], function(){

    Route::get('/register',[admin_controller::class,'create']);
    Route::post('/register',[admin_controller::class,'store']);
    
    Route::get('/login',[admin_controller::class,'login'])->name('login');
    Route::post('/adminlogin',[admin_controller::class,'adminlogin'])->name('adminlogin');
    
        
    });
    
    Route::group(['middleware'=>['admin_afterlogin']], function(){
    
    Route::get('/logout',[admin_controller::class,'logout']);
    Route::get('/home', [admin_controller::class,'dashboard'])->name('dashboard');
    Route::get('/change_password',[admin_controller::class,'changepasswordcreate']);
    Route::post('/change_password',[admin_controller::class,'changepassword']);
    

   	// category Route
	Route::get('/category/view', [App\Http\Controllers\CategoryController::class, 'index'])->name('category');
	Route::get('/category/add', [App\Http\Controllers\CategoryController::class, 'create'])->name('addCategory');
	Route::post('/category/view', [App\Http\Controllers\CategoryController::class, 'store'])->name('createCategory');
	Route::get('/category/edit/{id}', [App\Http\Controllers\CategoryController::class, 'edit'])->name('editCategory');
	Route::post('/category/edit/{id}', [App\Http\Controllers\CategoryController::class,'update'])->name('updateCategory');
	Route::get('/category/delete/{id}', [App\Http\Controllers\CategoryController::class, 'destroy'])->name('deleteCategory');
	Route::get('/category/show_product/{id}', [App\Http\Controllers\CategoryController::class, 'show_product'])->name('showProduct');
	Route::post('/update-order', [App\Http\Controllers\CategoryController::class, 'updateOrder'])->name('update_order_route');

     //product
     Route::get('/product/view', [App\Http\Controllers\ProductController::class, 'index'])->name('product');
     Route::get('/product/add', [App\Http\Controllers\ProductController::class, 'create'])->name('addProduct');
     Route::post('/product/view', [App\Http\Controllers\ProductController::class, 'store'])->name('createProduct');
     Route::get('/product/edit/{id}', [App\Http\Controllers\ProductController::class, 'edit'])->name('editProduct');
     Route::post('/product/edit/{id}', [App\Http\Controllers\ProductController::class,'update'])->name('updateProduct');
     Route::get('/product/delete/{id}', [App\Http\Controllers\ProductController::class, 'destroy'])->name('deleteProduct');
 Route::get('/product/editProduct/RemoveImage/{product_image_id}', [App\Http\Controllers\ProductController::class, 'destroyImage']);
 

	//Banner Route
	Route::get('/banner/view', [App\Http\Controllers\BannerController::class, 'index'])->name('banner');
	Route::get('/banner/add', [App\Http\Controllers\BannerController::class, 'create'])->name('addBanner');
	Route::post('/banner/view', [App\Http\Controllers\BannerController::class, 'store'])->name('createBanner');
	Route::get('/banner/edit/{id}', [App\Http\Controllers\BannerController::class, 'edit'])->name('editBanner');
	Route::post('/banner/edit/{id}', [App\Http\Controllers\BannerController::class,'update'])->name('updateBanner');
	Route::get('/banner/delete/{id}', [App\Http\Controllers\BannerController::class, 'destroy'])->name('deleteBanner');
     
   //cms
   Route::get('/cms/view', [App\Http\Controllers\CmsController::class, 'index'])->name('cms');
   Route::get('/cms/add', [App\Http\Controllers\CmsController::class, 'create'])->name('addCMS');
   Route::post('/cms/view', [App\Http\Controllers\CmsController::class, 'store'])->name('createCMS');
   Route::get('/cms/edit/{id}', [App\Http\Controllers\CmsController::class, 'edit'])->name('editCMS');
   Route::post('/cms/edit/{id}', [App\Http\Controllers\CmsController::class,'update'])->name('updateCMS');
   Route::get('/cms/delete/{id}', [App\Http\Controllers\CmsController::class, 'destroy'])->name('deleteCMS');

   //blog
// 	Route::get('/blog/view', [App\Http\Controllers\BlogController::class, 'index'])->name('blog');
// 	Route::get('/blog/add', [App\Http\Controllers\BlogController::class, 'create'])->name('addBlog');
// 	Route::post('/blog/view', [App\Http\Controllers\BlogController::class, 'store'])->name('createBlog');
// 	Route::get('/blog/edit/{id}', [App\Http\Controllers\BlogController::class, 'edit'])->name('editBlog');
// 	Route::post('/blog/edit/{id}', [App\Http\Controllers\BlogController::class,'update'])->name('updateBlog');
// 	Route::get('/blog/delete/{id}', [App\Http\Controllers\BlogController::class, 'destroy'])->name('deleteBlog');
    
   //gallery
	Route::get('/gallery/view', [App\Http\Controllers\GalleryController::class, 'index'])->name('gallery');
  Route::get('/gallery/add', [App\Http\Controllers\GalleryController::class, 'create'])->name('addGallery');
  Route::post('/gallery/view', [App\Http\Controllers\GalleryController::class, 'store'])->name('createGallery');
  Route::get('/gallery/edit/{id}', [App\Http\Controllers\GalleryController::class, 'edit'])->name('editGallery');
  Route::post('/gallery/edit/{id}', [App\Http\Controllers\GalleryController::class,'update'])->name('updateGallery');
  Route::get('/gallery/delete/{id}', [App\Http\Controllers\GalleryController::class, 'destroy'])->name('deleteGallery');
  Route::post('/gallery/save-gallery-image', [App\Http\Controllers\GalleryController::class, 'savegallerimage'])->name('savegallerimage');
  

  // Infrastructure Module
Route::get('/infrastructure/view', [App\Http\Controllers\InfrastructureController::class, 'index'])->name('infrastructure');
Route::get('/infrastructure/add', [App\Http\Controllers\InfrastructureController::class, 'create'])->name('addInfrastructure');
Route::post('/infrastructure/view', [App\Http\Controllers\InfrastructureController::class, 'store'])->name('createInfrastructure');
Route::get('/infrastructure/edit/{id}', [App\Http\Controllers\InfrastructureController::class, 'edit'])->name('editInfrastructure');
Route::post('/infrastructure/edit/{id}', [App\Http\Controllers\InfrastructureController::class,'update'])->name('updateInfrastructure');
Route::get('/infrastructure/delete/{id}', [App\Http\Controllers\InfrastructureController::class, 'destroy'])->name('deleteInfrastructure');
Route::post('/infrastructure/save-gallery-image', [App\Http\Controllers\InfrastructureController::class, 'saveInfrastructureImage'])->name('saveInfrastructureImage');

  
    //video
// 	Route::get('/video/view', [App\Http\Controllers\VideoController::class, 'index'])->name('video');
// 	Route::get('/video/add', [App\Http\Controllers\VideoController::class, 'create'])->name('addVideo');
// 	Route::post('/video/view', [App\Http\Controllers\VideoController::class, 'store'])->name('createVideo');
// 	Route::get('/video/edit/{id}', [App\Http\Controllers\VideoController::class, 'edit'])->name('editVideo');
// 	Route::post('/video/edit/{id}', [App\Http\Controllers\VideoController::class,'update'])->name('updateVideo');
// 	Route::get('/video/delete/{id}', [App\Http\Controllers\VideoController::class, 'destroy'])->name('deleteVideo');
	
	//certificate
    // Route::get('/certificate/view', [App\Http\Controllers\CertificateController::class, 'index'])->name('certificate');
    // Route::get('/certificate/add', [App\Http\Controllers\CertificateController::class, 'create'])->name('addCertificate');
    // Route::post('/certificate/view', [App\Http\Controllers\CertificateController::class, 'store'])->name('createCertificate');
    // Route::get('/certificate/edit/{id}', [App\Http\Controllers\CertificateController::class, 'edit'])->name('editCertificate');
    // Route::post('/certificate/edit/{id}', [App\Http\Controllers\CertificateController::class,'update'])->name('updateCertificate');
    // Route::get('/certificate/delete/{id}', [App\Http\Controllers\CertificateController::class, 'destroy'])->name('deleteCertificate');
      
   //testimonials
//   Route::get('/testimonials/view', [App\Http\Controllers\TestimonialsController::class, 'index'])->name('testimonials');
//   Route::get('/testimonials/add', [App\Http\Controllers\TestimonialsController::class, 'create'])->name('addTesti');
//   Route::post('/testimonials/view', [App\Http\Controllers\TestimonialsController::class, 'store'])->name('createTesti');
//   Route::get('/testimonials/edit/{id}', [App\Http\Controllers\TestimonialsController::class, 'edit'])->name('editTesti');
//   Route::post('/testimonials/edit/{id}', [App\Http\Controllers\TestimonialsController::class,'update'])->name('updateTesti');
//   Route::get('/testimonials/delete/{id}', [App\Http\Controllers\TestimonialsController::class, 'destroy'])->name('deleteTesti');
   
     //application
// 	Route::get('/application/view', [App\Http\Controllers\ApplicationController::class, 'index'])->name('application');
// 	Route::get('/application/add', [App\Http\Controllers\ApplicationController::class, 'create'])->name('addApplication');
// 	Route::post('/application/view', [App\Http\Controllers\ApplicationController::class, 'store'])->name('createApplication');
// 	Route::get('/application/edit/{id}', [App\Http\Controllers\ApplicationController::class, 'edit'])->name('editApplication');
// 	Route::post('/application/edit/{id}', [App\Http\Controllers\ApplicationController::class,'update'])->name('updateApplication');
// 	Route::get('/application/delete/{id}', [App\Http\Controllers\ApplicationController::class, 'destroy'])->name('deleteApplication');
   
     //industry
	Route::get('/industry/view', [App\Http\Controllers\IndustryController::class, 'index'])->name('industry');
	Route::get('/industry/add', [App\Http\Controllers\IndustryController::class, 'create'])->name('addIndustry');
	Route::post('/industry/view', [App\Http\Controllers\IndustryController::class, 'store'])->name('createIndustry');
	Route::get('/industry/edit/{id}', [App\Http\Controllers\IndustryController::class, 'edit'])->name('editIndustry');
	Route::post('/industry/edit/{id}', [App\Http\Controllers\IndustryController::class,'update'])->name('updateIndustry');
	Route::get('/industry/delete/{id}', [App\Http\Controllers\IndustryController::class, 'destroy'])->name('deleteIndustry');

	//contact Route
	Route::get('/contact/view', [App\Http\Controllers\ContactController::class, 'index'])->name('contact');
	Route::get('/contact/add', [App\Http\Controllers\ContactController::class, 'create'])->name('addContact');
	Route::post('/contact/view', [App\Http\Controllers\ContactController::class, 'store'])->name('createContact');
	Route::get('/contact/edit/{id}', [App\Http\Controllers\ContactController::class, 'edit'])->name('editContact');
	Route::post('/contact/edit/{id}', [App\Http\Controllers\ContactController::class,'update'])->name('updateContact');
	Route::get('/contact/delete/{id}', [App\Http\Controllers\ContactController::class, 'destroy'])->name('deleteContact');

	//client
// 	Route::get('/client/view', [App\Http\Controllers\ClientController::class, 'index'])->name('client');
// 	Route::get('/client/delete/{id}', [App\Http\Controllers\ClientController::class, 'destroy'])->name('deleteClient');
//   Route::post('/client/save-client-image', [App\Http\Controllers\ClientController::class, 'saveclientimage'])->name('saveclientimage');


    
   //contact us
   Route::get('/contactus/view', [App\Http\Controllers\ContactUsController::class, 'index'])->name('contactus');
    Route::get('/contactus/view_product_inquiry', [App\Http\Controllers\ContactUsController::class, 'product_inquiry'])->name('product_inquiry');   
    Route::get('/export-csv', [App\Http\Controllers\ContactUsController::class, 'exportCsv'])->name('export');
    Route::get('/contactus/view_quick_inquiry', [App\Http\Controllers\ContactUsController::class, 'quick_inquiry'])->name('quick_inquiry'); 
    Route::get('/contactus/view_inquiry', [App\Http\Controllers\ContactUsController::class, 'inquiry'])->name('inquiry'); 
    Route::get('/', function () { return view('index');});
 
    
    });
